	function [Xnum, Xden] = S_2_Z(G, Szeros, Spoles)
	
	% 	Computes the impedance in rational form corresponding to a 
	%	reflectance in terms of the poles and zeros of S.
 
	% 	Toolbox for ANALOG FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2007-06-25
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	%	To improve:		Check that S is a true reflection function	
	
	N = length(Spoles);	
	SnumPoly = G*ROOTS_2_POLY(Szeros);
	SdenPoly = ROOTS_2_POLY(Spoles);
	Xnum = POLYADD(SnumPoly, SdenPoly);
	Xden = POLYSUB(SdenPoly, SnumPoly);
	 
	
